package com.springapp.mvc;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping("/")
public class TestController {


/*
in resin.xml:
    <filter filter-name="gzip" filter-class="com.caucho.filters.GzipFilter"/>
    <filter-mapping url-pattern="*.api" filter-name="gzip"/>

resin + gzip hangs forever
caused by "Content-Length" in response header
*/

    @RequestMapping(value = "test.api", method = RequestMethod.GET)
    public void test(HttpServletResponse response) throws IOException {
        String s = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";

        //if this line is commented out, resin won't hang
        response.setIntHeader("Content-Length", s.length());

        response.getOutputStream().write(s.getBytes());

        System.out.println("response done");
    }
}